<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Clientables extends Model 
{

    protected $table = 'clientables';
    public $timestamps = false;
    protected $fillable = array('clientable_id', 'clientable_type', 'seen');

    public function notification()
    {
        return $this->morphedByMany('App\Models\Notification')->withPivot('seen');
    }

    public function post()
    {
        return $this->morphedByMany('App\Models\Post');
    }

    public function governorate()
    {
        return $this->morphedByMany('App\Models\Governorate');
    }

    public function blood_type()
    {
        return $this->morphedByMany('App\Models\BloodType');
    }

}